<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkConditionByParams(array $params)
 * @method getAnniversaryCardByParams(array $params)
 * @method getCardListByParams(array $params)
 */
class AnniversaryCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检测是否可以领取
     *
     * @param  int $serial 周年数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkCondition (int $serial) {
        return self::getClass()->checkCondition([
            "serial" => $serial,
        ]);
    }

    /**
     * 领取光年礼品卡
     *
     * @param  int $serial 周年数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAnniversaryCard (int $serial) {
        return self::getClass()->getAnniversaryCard([
            "serial" => $serial,
        ]);
    }

    /**
     * 获取光年卡列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCardList () {
        return self::getClass()->getCardList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\SpaceStation\AnniversaryCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\SpaceStation\AnniversaryCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}