<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\Recruitment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateByParams(array $params)
 * @method updateProgressByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class RecruitmentApply {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * update
     *
     * @param  int $id id [ require true ]
     * @support  int $staffId 工号 [ require false ]
     * @support  int $recruitmentPositionId 内聘岗位记录id [ require false ]
     * @support  int $newDepartmentId 新部门id [ require false ]
     * @support  int $newPositionId 新职位id [ require false ]
     * @support  int $oldDepartmentId 旧部门id [ require false ]
     * @support  int $oldPositionId 旧职位id [ require false ]
     * @support  string $city 所在城市 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * updateProgress
     *
     * @param  int $id id [ require true ]
     * @param  string $progress 进度 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateProgress (int $id, string $progress) {
        return self::getClass()->updateProgress([
            "id" => $id,
            "progress" => $progress,
        ]);
    }

    /**
     * list
     *
     * @support  int $staffId 工号 [ require false ]
     * @support  string $name 姓名 [ require false ]
     * @support  string $nickname 花名 [ require false ]
     * @support  string $progress 进度 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @support  array $newDepartmentIds 部门ids [ require false ]
     * @support  int $newPositionId 岗位id [ require false ]
     * @support  string $referee 咨询人 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * detail
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * delete
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\Recruitment\RecruitmentApply');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\Recruitment\RecruitmentApply');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}