<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffListByParams(array $params)
 * @method getRecordListByParams(array $params)
 * @method resetArchiveTicketNumByParams(array $params)
 */
class StaffRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 档案列表
     *
     * @support  array $deptIds 部门id集合，不传表示全部；或传递当前部门和它的子部门 [ require false ]
     * @support  string $staff 员工信息，姓名，昵称或工号 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStaffList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 档案列表.单人明细
     *
     * @param  string $staffId 员工工号 [ require true ]
     * @support  string $signupBeginAt 报名开始时间 [ require false ]
     * @support  string $signupEndAt 报名结束时间 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRecordList (string $staffId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getRecordList([
            "staffId" => $staffId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 重置员工操课券数量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetArchiveTicketNum () {
        return self::getClass()->resetArchiveTicketNum();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\SpaceStation\StaffRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\SpaceStation\StaffRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}