<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Talent;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|TalentStudent\ListSafeNamespace\StudentListCmd $params)
 * @method transferPoolByParams(array $params)
 * @method updateTeacherByParams(array $params)
 * @method removeByParams(array $params)
 * @method finishByParams(array $params)
 * @method detailByParams(array $params)
 * @method importTeacherByParams(array $params)
 * @method importScoreByParams(array $params)
 * @method exportByParams(array|TalentStudent\Export\StudentExportCmd $params)
 */
class TalentStudent {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 人才池列表
     *
     * @var  TalentStudent\ListSafeNamespace\StudentListCmd $cmd $cmd
     * @throws  \Exception
     * @return  TalentStudent\ListSafeNamespace\StudentListDTO
     */
    public static function list (TalentStudent\ListSafeNamespace\StudentListCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Invokes\ProjectThinking\Talent\TalentStudent\ListSafeNamespace\StudentListDTO"
        );
    }


    /**
     * 转移人才池
     *
     * @param  int $studentId 记录ID [ require true ]
     * @param  int $pool 目标池 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function transferPool (int $studentId, int $pool, int $operator) {
        return self::getClass()->transferPool([
            "studentId" => $studentId,
            "pool" => $pool,
            "operator" => $operator,
        ]);
    }

    /**
     * 变更带教
     *
     * @param  int $studentId 记录ID [ require true ]
     * @param  int $teacher 带教工号 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateTeacher (int $studentId, int $teacher, int $operator) {
        return self::getClass()->updateTeacher([
            "studentId" => $studentId,
            "teacher" => $teacher,
            "operator" => $operator,
        ]);
    }

    /**
     * 移出人才池
     *
     * @param  int $studentId 记录ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function remove (int $studentId, int $operator) {
        return self::getClass()->remove([
            "studentId" => $studentId,
            "operator" => $operator,
        ]);
    }

    /**
     * 确认完成
     *
     * @param  int $studentId 记录ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function finish (int $studentId, int $operator) {
        return self::getClass()->finish([
            "studentId" => $studentId,
            "operator" => $operator,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $studentId 记录ID [ require true ]
     * @throws  \Exception
     * @return  TalentStudent\Detail\StudentDetailDTO
     */
    public static function detail (int $studentId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detail([
                            "studentId" => $studentId,
                        ]),
            "\Mainto\Bridge\Invokes\ProjectThinking\Talent\TalentStudent\Detail\StudentDetailDTO"
        );
    }

    /**
     * 导入带教
     *
     * @param  array $data 导入数据 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTeacher (array $data, int $operator) {
        return self::getClass()->importTeacher([
            "data" => $data,
            "operator" => $operator,
        ]);
    }

    /**
     * 导入成绩
     *
     * @param  array $data 导入数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importScore (array $data) {
        return self::getClass()->importScore([
            "data" => $data,
        ]);
    }

    /**
     * 数据导出
     *
     * @var  TalentStudent\Export\StudentExportCmd $cmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function export (TalentStudent\Export\StudentExportCmd $cmd) {
        return self::getClass()->export($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Talent\TalentStudent');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Talent\TalentStudent');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}