<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\Recruitment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByStatusByParams(array $params)
 * @method listByDepartmentByParams(array $params)
 */
class RecruitmentTaken {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * listByStatus
     *
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listByStatus (string $status = 'open') {
        return self::getClass()->listByStatus([
            "status" => $status,
        ]);
    }

    /**
     * listByDepartment
     *
     * @param  int $newDepartmentId 部门id [ require true ]
     * @param  string $status 状态 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listByDepartment (int $newDepartmentId, string $status = 'open', int $page = 1, int $pageSize = 10) {
        return self::getClass()->listByDepartment([
            "newDepartmentId" => $newDepartmentId,
            "status" => $status,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\Recruitment\RecruitmentTaken');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\Recruitment\RecruitmentTaken');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}