<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkConditionByParams(array $params)
 * @method getAnniversaryCardByParams(array $params)
 */
class AnniversaryCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检测是否可以领取
     *
     * @param  int $staffId 员工工号 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function checkCondition (int $staffId = null) {
        return self::getClass()->checkCondition([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取一周年光年礼品卡
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAnniversaryCard () {
        return self::getClass()->getAnniversaryCard();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\SpaceStation\AnniversaryCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\SpaceStation\AnniversaryCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}