<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\WishCastle;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createTypeByParams(array $params)
 * @method getWishTypeByParams(array $params)
 * @method editTypeByParams(array $params)
 * @method deleteTypeByParams(array $params)
 */
class Type {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建愿望类型
     *
     * @param  string $type 愿望类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createType (string $type) {
        return self::getClass()->createType([
            "type" => $type,
        ]);
    }

    /**
     * 类型列表
     *
     * @param  string $type 搜索条件 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWishType (string $type = '') {
        return self::getClass()->getWishType([
            "type" => $type,
        ]);
    }

    /**
     * 修改愿望类型
     *
     * @param  string $type_id 愿望类型id [ require true ]
     * @param  string $type 愿望类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editType (string $type_id, string $type) {
        return self::getClass()->editType([
            "type_id" => $type_id,
            "type" => $type,
        ]);
    }

    /**
     * 删除愿望类型
     *
     * @param  string $_id 愿望类型id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteType (string $_id) {
        return self::getClass()->deleteType([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\WishCastle\Type');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\WishCastle\Type');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}