<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\Recruitment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateStatusByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method autoOpenByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getStaffUidByParams(array $params)
 */
class RecruitmentPosition {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @support  int $positionId 岗位id require false
     * @support  int $departmentId 部门id require false
     * @support  string $address 工作地点 require false
     * @support  string $startAt 开始时间 require false
     * @support  string $endAt 结束时间 require false
     * @support  int $refereeId 咨询人id require false
     * @support  array $notifyGroup 通知群体 require false
     * @support  string $desc 描述 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * update
     *
     * @param  int $id id [ require true ]
     * @support  int $positionId 岗位id require false
     * @support  int $departmentId 部门id require false
     * @support  string $address 工作地点 require false
     * @support  string $startAt 开始时间 require false
     * @support  string $endAt 结束时间 require false
     * @support  int $refereeId 咨询人id require false
     * @support  array $notifyGroup 通知群体 require false
     * @support  string $desc 描述 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * updateStatus
     *
     * @param  int $id 岗位id [ require true ]
     * @param  string $status 部门id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateStatus (int $id, string $status) {
        return self::getClass()->updateStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * list
     *
     * @support  int $positionId 岗位id require false
     * @support  array $departmentIds 部门ids require false
     * @support  string $address 工作地点 require false
     * @support  string $status 状态 require false
     * @support  string $referee 咨询人 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页记录数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * detail
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 自动开启职位
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoOpen () {
        return self::getClass()->autoOpen();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * delete
     *
     * @param  int $id 岗位id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取钉钉uid
     *
     * @param  int $id 内聘岗位记录id[唯一] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffUid (int $id) {
        return self::getClass()->getStaffUid([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\Recruitment\RecruitmentPosition');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\Recruitment\RecruitmentPosition');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}