<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\Talkout;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSuggestionListByParams(array $params)
 * @method getDetailByIdByParams(array $params)
 * @method addSuggestionByParams(array $params)
 * @method replyAppraiseByParams(array $params)
 * @method replyAgainAppraiseByParams(array $params)
 * @method upyunSignByParams(array $params)
 * @method getUpyunHostByParams(array $params)
 */
class Suggestion {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 投诉与建议列表
     *
     * @support  string $suggestionType 投诉与建议：类型 require false
     * @support  int $isDeal 处理结果：不传查询all，1 已处理，0 未处理 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSuggestionList () {
        return self::getClass()->getSuggestionList();
    }

    /**
     * 获取 投诉与建议 详情
     *
     * @param  int $id 投诉/建议 详情id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetailById (int $id) {
        return self::getClass()->getDetailById([
            "id" => $id,
        ]);
    }

    /**
     * 新增：投诉/建议
     *
     * @support  string $type 类型 require false
     * @support  array $topic 反馈主题（传英文标记，如果为空，传空数组） [ require true ]
     * @support  string $content 内容（字数限制 2000 个字） require false
     * @support  array $images 图片 URL 数组（如果为空，传空数组） require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function addSuggestion () {
        return self::getClass()->addSuggestion();
    }

    /**
     * 树洞回复评价
     *
     * @param  int $id 记录id [ require true ]
     * @support  string $appraiseType 评价类型 require false
     * @support  string $appraiseRemark 评价备注 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function replyAppraise (int $id) {
        return self::getClass()->replyAppraise([
            "id" => $id,
        ]);
    }

    /**
     * 树洞第二次评价
     *
     * @param  int $id 记录id [ require true ]
     * @support  string $appraiseType 评价类型 require false
     * @support  string $appraiseRemark 评价备注 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function replyAgainAppraise (int $id) {
        return self::getClass()->replyAgainAppraise([
            "id" => $id,
        ]);
    }

    /**
     * 又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function upyunSign () {
        return self::getClass()->upyunSign();
    }

    /**
     * 又拍云host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunHost () {
        return self::getClass()->getUpyunHost();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\Talkout\Suggestion');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\Talkout\Suggestion');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}