<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\WishCastle;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderListByParams(array $params)
 * @method shipByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表
     *
     * @support  string $state 状态位 require false
     * @support  int $staff_num 工号 require false
     * @support  string $name 员工姓名 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderList () {
        return self::getClass()->getOrderList();
    }

    /**
     * 发货/修改发货
     *
     * @support  string $order_id 订单id require false
     * @support  string $type 发货类型 require false
     * @support  string $logistics_name 物流名称 require false
     * @support  string $logistics_num 物流单号 require false
     * @support  string $note 领取说明 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function ship () {
        return self::getClass()->ship();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\WishCastle\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\WishCastle\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}