<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\WishCastle;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWishListByParams(array $params)
 * @method getWishTypeByParams(array $params)
 */
class Wish {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取愿望列表
     *
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getWishList () {
        return self::getClass()->getWishList();
    }

    /**
     * 愿望类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWishType () {
        return self::getClass()->getWishType();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\WishCastle\Wish');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\WishCastle\Wish');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}