<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\Talkout;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method configListByParams(array $params)
 * @method getSuggestionListByParams(array $params)
 * @method getDetailByIdByParams(array $params)
 * @method replyMessageByParams(array $params)
 * @method replyAgainMessageByParams(array $params)
 * @method cancelReplyByParams(array $params)
 * @method cancelAgainReplyByParams(array $params)
 * @method markMessageByParams(array $params)
 */
class Suggestion {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 投诉与建议列表：搜索配置参数
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function configList () {
        return self::getClass()->configList();
    }

    /**
     * 投诉与建议列表
     *
     * @support  array $departmentIds 部门id require false
     * @support  string $staff 姓名，花名，或工号 require false
     * @support  string $suggestionType 投诉与建议：类型 require false
     * @support  string $suggestionTopic 投诉与建议：主题 require false
     * @support  string $suggestionDepartment 投诉与建议：问题归属部门 require false
     * @support  int $isDeal 处理结果: 不传查询all，1 已处理，0 未处理 require false
     * @support  string $appraiseType 评价状态: 默认不传字段,satisfied满意,dissatisfied不满意,未评价空 require false
     * @support  int $page 页码 [ require true ]
     * @support  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSuggestionList () {
        return self::getClass()->getSuggestionList();
    }

    /**
     * 获取 投诉与建议 详情
     *
     * @param  int $id 投诉/建议 详情id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetailById (int $id) {
        return self::getClass()->getDetailById([
            "id" => $id,
        ]);
    }

    /**
     * 管理员回复消息
     *
     * @param  int $id 投诉/建议消息 id [ require true ]
     * @param  string $replyContent 回复内容（字数限制 2000 个字） [ require true ]
     * @param  int $isDeal 处理结果：不传查询all，1 已处理，0 未处理 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function replyMessage (int $id, string $replyContent, int $isDeal) {
        return self::getClass()->replyMessage([
            "id" => $id,
            "replyContent" => $replyContent,
            "isDeal" => $isDeal,
        ]);
    }

    /**
     * 管理员第二次回复消息
     *
     * @param  int $id 投诉/建议消息 id [ require true ]
     * @param  string $replyContent 回复内容（字数限制 2000 个字） [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function replyAgainMessage (int $id, string $replyContent) {
        return self::getClass()->replyAgainMessage([
            "id" => $id,
            "replyContent" => $replyContent,
        ]);
    }

    /**
     * 撤销第一次回复
     *
     * @param  int $id 投诉/建议消息 id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelReply (int $id) {
        return self::getClass()->cancelReply([
            "id" => $id,
        ]);
    }

    /**
     * 撤销第二次回复
     *
     * @param  int $id 投诉/建议消息 id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelAgainReply (int $id) {
        return self::getClass()->cancelAgainReply([
            "id" => $id,
        ]);
    }

    /**
     * 管理员标记消息
     *
     * @param  int $id 投诉/建议消息 id [ require true ]
     * @support  array $departments 问题归属部门（未选中，默认传空数组） require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function markMessage (int $id) {
        return self::getClass()->markMessage([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\Talkout\Suggestion');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\Talkout\Suggestion');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}