<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWishListByParams(array $params)
 * @method checkWishByParams(array $params)
 * @method createTypeByParams(array $params)
 * @method getWishTypeByParams(array $params)
 * @method editTypeByParams(array $params)
 * @method modifyWishValueByParams(array $params)
 */
class WishManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取愿望列表
     *
     * @support  string $state 状态（wait_review-待审核 pass-通过 un_pass-未通过） require false
     * @support  int $staff_num 用户工号 require false
     * @support  string $name 员工姓名 require false
     * @support  string $type_id 愿望类型id require false
     * @support  string $created_at_start 提交时间起 require false
     * @support  string $created_at_end 提交时间止 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @support  bool $all 是否返回所有结果 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWishList () {
        return self::getClass()->getWishList();
    }

    /**
     * 审核愿望
     *
     * @support  array $_ids 审核id require false
     * @support  string $state 状态（wait_review-待审核 pass-通过 un_pass-未通过） require false
     * @support  int $score 礼物分值 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkWish () {
        return self::getClass()->checkWish();
    }

    /**
     * 创建愿望类型
     *
     * @param  string $type 愿望类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createType (string $type) {
        return self::getClass()->createType([
            "type" => $type,
        ]);
    }

    /**
     * 愿望类型
     *
     * @param  string $type 搜索条件 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWishType (string $type = '') {
        return self::getClass()->getWishType([
            "type" => $type,
        ]);
    }

    /**
     * 修改愿望类型
     *
     * @param  string $type_id 愿望类型id [ require true ]
     * @param  string $type 愿望类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editType (string $type_id, string $type) {
        return self::getClass()->editType([
            "type_id" => $type_id,
            "type" => $type,
        ]);
    }

    /**
     * 修改愿望值【总值】
     *
     * @support  int $wish_val 愿望值【可为负数】 [ require true ]
     * @support  string $note 备注 [ require true ]
     * @support  int $staff_num 员工工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyWishValue () {
        return self::getClass()->modifyWishValue();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'WishManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'WishManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}