<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderListByParams(array $params)
 * @method exportByParams(array $params)
 * @method getStateCountByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单列表
     *
     * @support  string $state 状态位 require false
     * @support  int $staff_num 工号 require false
     * @support  string $name 员工姓名 require false
     * @support  string $from 数据来源 require false
     * @support  string $type 类型 require false
     * @support  string $from_id 数据来源的id require false
     * @support  int $score 愿望值数量 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @support  bool $all 是否返回所有结果 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderList () {
        return self::getClass()->getOrderList();
    }

    /**
     * 获取订单信息(导出用)
     *
     * @support  string $state 状态位 require false
     * @support  string $from 数据来源 require false
     * @support  string $type 类型 require false
     * @support  string $from_id 数据来源的id require false
     * @support  int $score 愿望值数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function export () {
        return self::getClass()->export();
    }

    /**
     * 订单状态统计
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStateCount () {
        return self::getClass()->getStateCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}