<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\WishCastle;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method exchangeGiftByParams(array $params)
 * @method getGiftsByParams(array $params)
 * @method getGiftListByParams(array $params)
 */
class Gift {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 兑换礼物
     *
     * @param  string $gift_id 礼物id [ require true ]
     * @param  int $wish_val 愿望值 [ require true ]
     * @support  string $deliverType 提货方式 require false
     * @support  string $address 收件地址 require false
     * @support  string $phone 收件电话 require false
     * @support  string $name 收件人 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function exchangeGift (string $gift_id, int $wish_val) {
        return self::getClass()->exchangeGift([
            "gift_id" => $gift_id,
            "wish_val" => $wish_val,
        ]);
    }

    /**
     * 我的愿望【我的礼物】
     *
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getGifts () {
        return self::getClass()->getGifts();
    }

    /**
     * 愿望池-礼物池
     *
     * @param  string $type_id 礼物类别 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGiftList (string $type_id, int $page = 1, int $page_size = 10) {
        return self::getClass()->getGiftList([
            "type_id" => $type_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\WishCastle\Gift');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\WishCastle\Gift');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}