<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBroadcastListByParams(array $params)
 * @method getBroadcastDetailByParams(array $params)
 * @method likeByParams(array $params)
 * @method dislikeByParams(array $params)
 * @method awardByParams(array $params)
 */
class PlanetBroadcast {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 广播列表
     *
     * @support  string $type 类型 require false
     * @support  string $title 标题 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBroadcastList () {
        return self::getClass()->getBroadcastList();
    }

    /**
     * 广播详情
     *
     * @param  string $_id 公告id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBroadcastDetail (string $_id) {
        return self::getClass()->getBroadcastDetail([
            "_id" => $_id,
        ]);
    }

    /**
     * 点赞
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function like (string $_id) {
        return self::getClass()->like([
            "_id" => $_id,
        ]);
    }

    /**
     * 取消点赞
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dislike (string $_id) {
        return self::getClass()->dislike([
            "_id" => $_id,
        ]);
    }

    /**
     * 阅读收益
     *
     * @param  string $_id 广播id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function award (string $_id) {
        return self::getClass()->award([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'PlanetBroadcast');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'PlanetBroadcast');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}