<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method dataManageByParams(array $params)
 * @method getStaffDetailByParams(array $params)
 */
class Data {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 数据管理
     *
     * @param  int $staff_num 工号 [ require true ]
     * @param  string $name 姓名 [ require true ]
     * @param  int $page 页数 [ require true ]
     * @param  int $page_size 每页显示数据量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function dataManage (int $staff_num = null, int $page = 1, int $page_size = 10, string $name = '') {
        return self::getClass()->dataManage([
            "staff_num" => $staff_num,
            "page" => $page,
            "page_size" => $page_size,
            "name" => $name,
        ]);
    }

    /**
     * 获取员工数据详情
     *
     * @support  int $staff_num 工号 [ require true ]
     * @support  string $from 数据来源 require false
     * @support  string $type 类型 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffDetail () {
        return self::getClass()->getStaffDetail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Data');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Data');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}