<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getExerciseLogListByParams(array $params)
 * @method uploadExerciseLogsByParams(array $params)
 */
class StaffExerciseLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 档案列表.单人明细.健身记录
     *
     * @param  string $staffId 员工工号 [ require true ]
     * @support  string $beginAt 开始日期 require false
     * @support  string $endAt 结束日期 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExerciseLogList (string $staffId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getExerciseLogList([
            "staffId" => $staffId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 健身记录上传
     *
     * @support  array $logs 健身记录，数据为[[staffId, beginAt, endAt]] 的数组 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadExerciseLogs () {
        return self::getClass()->uploadExerciseLogs();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\SpaceStation\StaffExerciseLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\SpaceStation\StaffExerciseLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}