<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotographCouponListByParams(array $params)
 * @method getPhotographCouponByParams(array $params)
 * @method activatePhotographCouponByParams(array $params)
 * @method updatePhotographCouponFirstHookByParams(array $params)
 * @method deletePhotographCouponFirstHookByParams(array $params)
 * @method updatePhotographCouponResignationHookByParams(array $params)
 * @method cronPhotographCouponsByParams(array $params)
 * @method cronPositivePhotographCouponsByParams(array $params)
 * @method cronAbolishPhotographCouponsByParams(array $params)
 * @method cronDeletePhotographRecordsByParams(array $params)
 */
class CouponPhotograph {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄折扣券列表
     *
     * @param  bool $isActivated 是否已领取 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographCouponList (bool $isActivated, int $page, int $pageSize) {
        return self::getClass()->getPhotographCouponList([
            "isActivated" => $isActivated,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 拍摄折扣券详情
     *
     * @param  int $id 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographCoupon (int $id) {
        return self::getClass()->getPhotographCoupon([
            "id" => $id,
        ]);
    }

    /**
     * 拍摄折扣券.领取
     *
     * @param  int $id 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function activatePhotographCoupon (int $id) {
        return self::getClass()->activatePhotographCoupon([
            "id" => $id,
        ]);
    }

    /**
     * 新伙伴入职发放
     *
     * @param  int $staff_id 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePhotographCouponFirstHook (int $staff_id) {
        return self::getClass()->updatePhotographCouponFirstHook([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 员工离职删除记录
     *
     * @param  int $staff_id 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deletePhotographCouponFirstHook (int $staff_id) {
        return self::getClass()->deletePhotographCouponFirstHook([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 员工复职发放
     *
     * @param  int $staffId 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePhotographCouponResignationHook (int $staffId) {
        return self::getClass()->updatePhotographCouponResignationHook([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 发放拍摄折扣券定时任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronPhotographCoupons () {
        return self::getClass()->cronPhotographCoupons();
    }

    /**
     * 转正补发定时任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronPositivePhotographCoupons () {
        return self::getClass()->cronPositivePhotographCoupons();
    }

    /**
     * 拍摄折扣券作废定时任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronAbolishPhotographCoupons () {
        return self::getClass()->cronAbolishPhotographCoupons();
    }

    /**
     * 拍摄折扣券删除定时任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronDeletePhotographRecords () {
        return self::getClass()->cronDeletePhotographRecords();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\SpaceStation\CouponPhotograph');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\SpaceStation\CouponPhotograph');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}