<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOneGiftByParams(array $params)
 * @method editGiftByParams(array $params)
 * @method getGiftListByParams(array $params)
 * @method releaseGiftByParams(array $params)
 * @method shipByParams(array $params)
 */
class GiftManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建礼物【管理端】
     *
     * @support  string $type_id 愿望类型id [ require true ]
     * @support  array $images 图片 [ require true ]
     * @support  string $gift_name 礼物名称 [ require true ]
     * @support  string $gift_detail 礼物介绍 [ require true ]
     * @support  int $score 兑换所需 [ require true ]
     * @support  string $state 状态位【released|not_released】 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOneGift () {
        return self::getClass()->createOneGift();
    }

    /**
     * 编辑礼物【管理端】
     *
     * @support  string $_id id [ require true ]
     * @support  string $type_id 礼物类别 require false
     * @support  array $images 图片 require false
     * @support  string $gift_name 礼物名称 require false
     * @support  string $gift_detail 礼物介绍 require false
     * @support  int $score 兑换所需 require false
     * @support  string $state 状态位 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editGift () {
        return self::getClass()->editGift();
    }

    /**
     * 愿望池-礼物池【礼物数量统计、礼物更新时间】【通用】
     *
     * @support  string $type_id 礼物类别 require false
     * @support  string $gift_name 礼物名称 require false
     * @support  string $creator 提交人姓名 require false
     * @support  string $state 状态位 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiftList () {
        return self::getClass()->getGiftList();
    }

    /**
     * 上架-下架【管理端】
     *
     * @param  string $gift_id 礼物id [ require true ]
     * @param  string $state 状态【是否上架】 [ require true ]
     * @param  int $score 礼物分值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function releaseGift (string $gift_id, string $state, int $score = 0) {
        return self::getClass()->releaseGift([
            "gift_id" => $gift_id,
            "state" => $state,
            "score" => $score,
        ]);
    }

    /**
     * 发货(修改发货)
     *
     * @support  string $order_id 订单id require false
     * @support  string $type 发货类型 require false
     * @support  string $logistics_name 物流名称 require false
     * @support  string $logistics_num 物流单号 require false
     * @support  string $note 领取说明 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function ship () {
        return self::getClass()->ship();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'GiftManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'GiftManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}