<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllBannersByParams(array $params)
 * @method getSpaceStationIndexByParams(array $params)
 * @method getActivityListByParams(array $params)
 * @method getActivityByParams(array $params)
 * @method signupActivityByParams(array $params)
 * @method signinActivityByParams(array $params)
 * @method getStaffArchiveByParams(array $params)
 * @method getMyActivityListByParams(array $params)
 * @method getInformationListByParams(array $params)
 * @method getInformationByParams(array $params)
 * @method addRecordByParams(array $params)
 * @method awardByParams(array $params)
 * @method hasWishNoticeByParams(array $params)
 * @method getWishRecordByParams(array $params)
 * @method getServerTimeByParams(array $params)
 * @method webSocketByParams(array $params)
 */
class SpaceStation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有的banner
     *
     * @support  string $title 标题 
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  array
     */
    public static function getAllBanners () {
        return self::getClass()->getAllBanners();
    }

    /**
     * 首页
     *
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getSpaceStationIndex () {
        return self::getClass()->getSpaceStationIndex();
    }

    /**
     * 活动广场列表
     *
     * @param  string $status 报名状态，signing 报名中，signed 已结束，signtodo 即将开始 [ require true ]
     * @param  string $type 活动类型，knowledge 表示知识补给，energy 表示能量空间 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityList (string $status, string $type, int $page, int $pageSize) {
        return self::getClass()->getActivityList([
            "status" => $status,
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 不需要权限设置，这边有个消息通知发送，点击跳转到活动详情（用户端），没有x-stream-id附带
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivity (int $id) {
        return self::getClass()->getActivity([
            "id" => $id,
        ]);
    }

    /**
     * 活动报名
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function signupActivity (int $id) {
        return self::getClass()->signupActivity([
            "id" => $id,
        ]);
    }

    /**
     * 活动签到
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function signinActivity (int $id) {
        return self::getClass()->signinActivity([
            "id" => $id,
        ]);
    }

    /**
     * 员工档案.操课券和学分
     *
     * @param  int $staffId 员工id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffArchive (int $staffId) {
        return self::getClass()->getStaffArchive([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 活动广场.我的活动
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMyActivityList (int $page, int $pageSize) {
        return self::getClass()->getMyActivityList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 生活助手和福利礼包列表
     *
     * @support  string $type 资讯类型，assistant 表示生活助手，outerWelfare 表示外部福利 
     * @support  string $childType 子版块 
     * @support  string $title 标题 
     * @support  bool $isAll 是否查询全部 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInformationList (int $page, int $pageSize) {
        return self::getClass()->getInformationList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 资讯详情获得
     *
     * @param  int $id 资讯id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInformation (int $id) {
        return self::getClass()->getInformation([
            "id" => $id,
        ]);
    }

    /**
     * 资讯阅读量
     *
     * @param  int $id 资讯id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addRecord (int $id) {
        return self::getClass()->addRecord([
            "id" => $id,
        ]);
    }

    /**
     * 资讯阅读添加愿望值
     *
     * @param  int $id 资讯id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function award (int $id) {
        return self::getClass()->award([
            "id" => $id,
        ]);
    }

    /**
     * 愿望城堡的愿望值变更提示标记
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function hasWishNotice () {
        return self::getClass()->hasWishNotice();
    }

    /**
     * 根据是否提醒过获取愿望值变更记录
     *
     * @support  bool $hasNotice 是否提醒过,false否,true是 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWishRecord () {
        return self::getClass()->getWishRecord();
    }

    /**
     * 服务器时间
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getServerTime () {
        return self::getClass()->getServerTime();
    }

    /**
     * websocket连接
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function webSocket () {
        return self::getClass()->webSocket();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\SpaceStation\SpaceStation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\SpaceStation\SpaceStation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}