<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCoffeeCouponListByParams(array $params)
 * @method cronCoffeeCouponsByParams(array $params)
 * @method newStaffCoffeeCouponsByParams(array $params)
 * @method recoverStaffCoffeeCouponsByParams(array $params)
 * @method getCouponInfoByParams(array $params)
 * @method checkCoffeeCouponByParams(array $params)
 * @method exportCoffeeCouponListByParams(array $params)
 */
class CouponCoffee {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 咖啡券列表
     *
     * @param  bool $isUsed 是否已使用 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCoffeeCouponList (bool $isUsed) {
        return self::getClass()->getCoffeeCouponList([
            "isUsed" => $isUsed,
        ]);
    }

    /**
     * 发放咖啡券定时任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCoffeeCoupons () {
        return self::getClass()->cronCoffeeCoupons();
    }

    /**
     * 新人入职发放咖啡券
     *
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newStaffCoffeeCoupons (int $staff_id) {
        return self::getClass()->newStaffCoffeeCoupons([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 重新入职发放咖啡券
     *
     * @param  int $staffId 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverStaffCoffeeCoupons (int $staffId) {
        return self::getClass()->recoverStaffCoffeeCoupons([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 移除登录权限判断，微信端用户登录使用微信特定权限判定
     *
     * @param  string $id 咖啡券记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponInfo (string $id) {
        return self::getClass()->getCouponInfo([
            "id" => $id,
        ]);
    }

    /**
     * 移除登录权限判断，微信端用户登录使用微信特定权限判定
     *
     * @param  string $id 咖啡券记录id [ require true ]
     * @param  string $prodName 商品名称 [ require true ]
     * @param  float $prodPrice 商品原价 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkCoffeeCoupon (string $id, string $prodName, float $prodPrice) {
        return self::getClass()->checkCoffeeCoupon([
            "id" => $id,
            "prodName" => $prodName,
            "prodPrice" => $prodPrice,
        ]);
    }

    /**
     * 咖啡券列表.导出
     *
     * @support  string $beginAt 开始日期 
     * @support  string $endAt 结束日期 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exportCoffeeCouponList (int $page, int $pageSize) {
        return self::getClass()->exportCoffeeCouponList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\SpaceStation\CouponCoffee');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\SpaceStation\CouponCoffee');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}