<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\Recruitment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateStatusByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 */
class RecruitmentBanner {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @support  string $name 名称 
     * @support  string $coverImage 封面 
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * update
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  string $coverImage 封面 
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * updateStatus
     *
     * @param  int $id 岗位id [Original type uint] [ require true ]
     * @param  string $status 部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStatus (int $id, string $status) {
        return self::getClass()->updateStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * list
     *
     * @support  int $name 岗位id [Original type uint] 
     * @support  int $status 部门id [Original type uint] 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 每页记录数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * detail
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * delete
     *
     * @param  int $id 岗位id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\Recruitment\RecruitmentBanner');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\Recruitment\RecruitmentBanner');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}