<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\Recruitment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateStatusByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class RecruitmentTaken {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @support  int $staffId 工号 [Original type uint] 
     * @support  int $newDepartmentId 新部门id [Original type uint] 
     * @support  int $newPositionId 新职位id [Original type uint] 
     * @support  int $oldDepartmentId 旧部门id [Original type uint] 
     * @support  int $oldPositionId 旧职位id [Original type uint] 
     * @support  string $imageUrl 图片地址 
     * @support  string $successAt 应聘成功时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * update
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  int $staffId 工号 [Original type uint] 
     * @support  int $newDepartmentId 新部门id [Original type uint] 
     * @support  int $newPositionId 新职位id [Original type uint] 
     * @support  int $oldDepartmentId 旧部门id [Original type uint] 
     * @support  int $oldPositionId 旧职位id [Original type uint] 
     * @support  string $imageUrl 图片地址 
     * @support  string $successAt 应聘成功时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * updateStatus
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $status status [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStatus (int $id, string $status) {
        return self::getClass()->updateStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * list
     *
     * @support  int $staffId 工号 [Original type uint] 
     * @support  string $name 姓名 
     * @support  string $nickname 花名 
     * @support  array $newDepartmentIds 新部门id 
     * @support  string $status 状态 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 每页记录数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * detail
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * delete
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\Recruitment\RecruitmentTaken');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\Recruitment\RecruitmentTaken');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}