<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\Recruitment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method myListByParams(array $params)
 * @method detailByParams(array $params)
 * @method submitByParams(array $params)
 * @method getSubmitDetailByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 */
class RecruitmentApply {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * myList
     *
     * @param  array $progress 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function myList (array $progress = []) {
        return self::getClass()->myList([
            "progress" => $progress,
        ]);
    }

    /**
     * detail
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * submit
     *
     * @param  int $id 职位记录id [Original type uint] [ require true ]
     * @param  array $extraInfo 额外信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $id, array $extraInfo = []) {
        return self::getClass()->submit([
            "id" => $id,
            "extraInfo" => $extraInfo,
        ]);
    }

    /**
     * getSubmitDetail
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSubmitDetail (int $id) {
        return self::getClass()->getSubmitDetail([
            "id" => $id,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\Recruitment\RecruitmentApply');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\Recruitment\RecruitmentApply');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}