<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\Recruitment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateStatusByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method exportByParams(array $params)
 * @method deleteByParams(array $params)
 */
class RecruitmentPosition {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @support  int $positionId 岗位id [Original type uint] 
     * @support  int $departmentId 部门id [Original type uint] 
     * @support  string $address 工作地点 
     * @support  string $startAt 开始时间 
     * @support  string $endAt 结束时间 
     * @support  int $refereeId 咨询人id [Original type uint] 
     * @support  int $notifyGroup 通知群体 [Original type uint] 
     * @support  string $desc 描述 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * update
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  int $positionId 岗位id [Original type uint] 
     * @support  int $departmentId 部门id [Original type uint] 
     * @support  string $address 工作地点 
     * @support  string $startAt 开始时间 
     * @support  string $endAt 结束时间 
     * @support  int $refereeId 咨询人id [Original type uint] 
     * @support  int $notifyGroup 通知群体 [Original type uint] 
     * @support  string $desc 描述 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * updateStatus
     *
     * @param  int $id 岗位id [Original type uint] [ require true ]
     * @param  string $status 部门id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function updateStatus (int $id, string $status) {
        return self::getClass()->updateStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * list
     *
     * @support  int $positionId 岗位id [Original type uint] 
     * @support  int $departmentId 部门id [Original type uint] 
     * @support  string $address 工作地点 
     * @support  string $status 开始时间 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 每页记录数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * detail
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * export
     *
     * @support  int $positionId 岗位id [Original type uint] 
     * @support  int $departmentId 部门id [Original type uint] 
     * @support  string $address 工作地点 
     * @support  string $startAt 开始时间 
     * @support  string $endAt 结束时间 
     * @support  int $refereeId 咨询人id [Original type uint] 
     * @support  int $notifyGroup 通知群体 [Original type uint] 
     * @support  string $desc 描述 
     * @throws  \Exception
     * @return  array
     */
    public static function export () {
        return self::getClass()->export();
    }

    /**
     * delete
     *
     * @param  int $id 岗位id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\Recruitment\RecruitmentPosition');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\Recruitment\RecruitmentPosition');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}