<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInformationListByParams(array $params)
 * @method addInformationByParams(array $params)
 * @method editInformationByParams(array $params)
 * @method deleteInformationByParams(array $params)
 * @method getInformationByParams(array $params)
 */
class Information {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 资讯列表
     *
     * @support  string $title 标题 
     * @support  string $type 资讯类型，information 表示生活助手，welfare 表示外部合作福利  
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInformationList (int $page, int $pageSize) {
        return self::getClass()->getInformationList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 资讯新增
     *
     * @support  string $title 标题 [ require true ]
     * @support  string $abstract 概要 
     * @support  string $coverImage 封面图 [ require true ]
     * @support  string $description 资讯正文 [ require true ]
     * @support  string $type 资讯类型，assistant 表示生活助手，welfare 表示外部合作福利  [ require true ]
     * @support  array $extraInfo 可传空，格式：外部跳转 [ selected:1, url:http:xxxxxx]; 1 为外部跳转，0 为无 
     * @support  array $rules 规则组[[&#039;department_id&#039; =&gt; &#039;&#039;, &#039;job_id&#039; =&gt; &#039;&#039;, &#039;level&#039; =&gt; &#039;&#039;]] 
     * @support  array $includes 包含的staffIds 
     * @support  array $excludes 排除的staffIds 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addInformation () {
        return self::getClass()->addInformation();
    }

    /**
     * 资讯编辑
     *
     * @support  int $id 资讯id [Original type uint] [ require true ]
     * @support  string $title 标题 
     * @support  string $abstract 概要 
     * @support  string $coverImage 封面图 
     * @support  string $description 资讯正文 
     * @support  string $type 资讯类型，assistant 表示生活助手，welfare 表示外部合作福利  
     * @support  array $extraInfo 可传空，格式：外部跳转 [ selected:1, url:http:xxxxxx]; 1 为外部跳转，0 为无 
     * @support  array $rules 规则组[[&#039;department_id&#039; =&gt; &#039;&#039;, &#039;job_id&#039; =&gt; &#039;&#039;, &#039;level&#039; =&gt; &#039;&#039;]] 
     * @support  array $includes 包含的staffIds 
     * @support  array $excludes 排除的staffIds 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editInformation () {
        return self::getClass()->editInformation();
    }

    /**
     * 资讯删除
     *
     * @param  int $id 资讯id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteInformation (int $id) {
        return self::getClass()->deleteInformation([
            "id" => $id,
        ]);
    }

    /**
     * 资讯详情获得
     *
     * @param  int $id 资讯id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInformation (int $id) {
        return self::getClass()->getInformation([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\SpaceStation\Information');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\SpaceStation\Information');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}