<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createWishByParams(array $params)
 * @method getWishListByParams(array $params)
 * @method wishRankingListByParams(array $params)
 * @method loadingEnergyByParams(array $params)
 * @method dailyLoadingEnergyByParams(array $params)
 * @method getWishTypeByParams(array $params)
 * @method deleteWishTypeByParams(array $params)
 */
class Wish {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 上传愿望
     *
     * @support  string $type_id 愿望id [ require true ]
     * @support  string $wish_name 愿望名称 [ require true ]
     * @support  string $wish_detail 愿望详情 [ require true ]
     * @support  array $images 图片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createWish () {
        return self::getClass()->createWish();
    }

    /**
     * 获取愿望列表
     *
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页数量 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getWishList () {
        return self::getClass()->getWishList();
    }

    /**
     * 获取愿望值排行【100名】
     *
     * @throws  \Exception
     * @return  array
     */
    public static function wishRankingList () {
        return self::getClass()->wishRankingList();
    }

    /**
     * 需要产生的能量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function loadingEnergy () {
        return self::getClass()->loadingEnergy();
    }

    /**
     * 日常产生能量【签到】
     *
     * @param  int $staff_num 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dailyLoadingEnergy (int $staff_num) {
        return self::getClass()->dailyLoadingEnergy([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 愿望类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWishType () {
        return self::getClass()->getWishType();
    }

    /**
     * 删除愿望类型
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteWishType (string $_id) {
        return self::getClass()->deleteWishType([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Wish');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Wish');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}