<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createBroadcastByParams(array $params)
 * @method editBroadcastByParams(array $params)
 * @method getBroadcastDetailByParams(array $params)
 * @method getBroadcastListByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 * @method exportUnreadByParams(array $params)
 */
class PlanetBroadcastManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录【state默认上线】
     *
     * @support  string $type 类型 [ require true ]
     * @support  string $image 图片 [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  int $read_time 需阅读时间 
     * @support  int $wish_value 愿望值 
     * @support  string $content 内容 [ require true ]
     * @support  array $to_group 分组id [ require true ]
     * @support  array $appendix 附件 
     * @support  array $extend 拓展信息 
     * @support  bool $is_broadcast 是否广播 
     * @throws  \Exception
     * @return  array
     */
    public static function createBroadcast () {
        return self::getClass()->createBroadcast();
    }

    /**
     * 更新广播
     *
     * @support  string $_id id [ require true ]
     * @support  string $type 类型 
     * @support  string $image 图片 
     * @support  string $title 标题 
     * @support  int $read_time 需阅读时间 
     * @support  int $wish_value 愿望值 
     * @support  string $content 内容 
     * @support  array $to_group 分组id 
     * @support  array $appendix 附件 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editBroadcast () {
        return self::getClass()->editBroadcast();
    }

    /**
     * 获取广播详情
     *
     * @param  string $_id 公告id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBroadcastDetail (string $_id) {
        return self::getClass()->getBroadcastDetail([
            "_id" => $_id,
        ]);
    }

    /**
     * 广播列表查询
     *
     * @support  string $title 标题 
     * @support  int $to_group 分组id 
     * @support  string $type 类型 
     * @support  string $created_at_start 添加日期起 
     * @support  string $created_at_end 添加日期止 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @support  bool $all 是否返回所有结果 
     * @throws  \Exception
     * @return  array
     */
    public static function getBroadcastList () {
        return self::getClass()->getBroadcastList();
    }

    /**
     * 上线
     *
     * @support  string $_id id [ require true ]
     * @support  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online () {
        return self::getClass()->online();
    }

    /**
     * 下线
     *
     * @support  string $_id id [ require true ]
     * @support  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline () {
        return self::getClass()->offline();
    }

    /**
     * 导出未阅读数
     *
     * @param  string $broadcast_id 广播id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exportUnread (string $broadcast_id) {
        return self::getClass()->exportUnread([
            "broadcast_id" => $broadcast_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'PlanetBroadcastManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'PlanetBroadcastManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}