<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createThinkByParams(array $params)
 * @method getThinksByParams(array $params)
 * @method getThinkListByParams(array $params)
 * @method getThinkTypeByParams(array $params)
 * @method updateThinkStateByParams(array $params)
 * @method editThinkByParams(array $params)
 */
class Think {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建脑洞
     *
     * @support  string $recommend_reason 推荐理由 [ require true ]
     * @support  string $type_id 点子类型id [ require true ]
     * @support  array $images 图片地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createThink () {
        return self::getClass()->createThink();
    }

    /**
     * 获取我的脑洞
     *
     * @support  string $state 状态（wait_review-待审核 pass-通过 un_pass-未通过） 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getThinks () {
        return self::getClass()->getThinks();
    }

    /**
     * 获取脑洞列表
     *
     * @support  string $type_id 点子类型id 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getThinkList () {
        return self::getClass()->getThinkList();
    }

    /**
     * 获取脑洞类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getThinkType () {
        return self::getClass()->getThinkType();
    }

    /**
     * 修改脑洞状态
     *
     * @param  string $_id 点子id [ require true ]
     * @param  string $state 脑洞状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateThinkState (string $_id, string $state) {
        return self::getClass()->updateThinkState([
            "_id" => $_id,
            "state" => $state,
        ]);
    }

    /**
     * 编辑脑洞
     *
     * @support  array $_ids 脑洞id [ require true ]
     * @support  string $recommend_reason 描述 
     * @support  string $type_id 点子类型id 
     * @support  array $images 图片地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editThink () {
        return self::getClass()->editThink();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Think');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Think');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}