<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffInfoByParams(array $params)
 * @method getStaffUidByBroadcastIdByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 钉钉端获取员工信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffInfo () {
        return self::getClass()->getStaffInfo();
    }

    /**
     * 获取钉钉uid
     *
     * @param  string $broadcast_id 广播id[唯一] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffUidByBroadcastId (string $broadcast_id) {
        return self::getClass()->getStaffUidByBroadcastId([
            "broadcast_id" => $broadcast_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}