<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getThinkListByParams(array $params)
 * @method createTypeByParams(array $params)
 * @method getThinkTypeByParams(array $params)
 * @method checkThinkByParams(array $params)
 * @method editThinkByParams(array $params)
 * @method editTypeByParams(array $params)
 * @method releasedThinkByParams(array $params)
 * @method delThinkTypeByParams(array $params)
 * @method thinkAppraiseByParams(array $params)
 */
class ThinkManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取脑洞列表
     *
     * @support  string $state 状态（wait_review-待审核 pass-通过 un_pass-未通过 stash-暂存） 
     * @support  string $created_at_start 开始时间 
     * @support  string $created_at_end 结束时间 
     * @support  int $staff_num 用户工号 
     * @support  string $name 姓名 
     * @support  string $type_id 点子类型id 
     * @support  string $appraise 评选 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getThinkList () {
        return self::getClass()->getThinkList();
    }

    /**
     * 创建脑洞类型
     *
     * @param  string $type 脑洞类型 [ require true ]
     * @param  int $wish_value 愿望值 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createType (string $type, int $wish_value) {
        return self::getClass()->createType([
            "type" => $type,
            "wish_value" => $wish_value,
        ]);
    }

    /**
     * 获取脑洞类型
     *
     * @param  string $type 搜索条件 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getThinkType (string $type = '') {
        return self::getClass()->getThinkType([
            "type" => $type,
        ]);
    }

    /**
     * 审核脑洞
     *
     * @support  array $_ids 审核id 
     * @support  string $state 状态（wait_review-待审核 pass-通过 un_pass-未通过） 
     * @support  string $un_pass_reason 不通过原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkThink () {
        return self::getClass()->checkThink();
    }

    /**
     * 修改脑洞
     *
     * @support  array $_ids 脑洞id [ require true ]
     * @support  string $recommend_reason 描述 
     * @support  string $type_id 点子类型id 
     * @support  array $images 图片地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editThink () {
        return self::getClass()->editThink();
    }

    /**
     * 修改脑洞类型
     *
     * @param  string $type_id 脑洞类型id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $wish_value 愿望值 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function editType (string $type_id, string $type, int $wish_value) {
        return self::getClass()->editType([
            "type_id" => $type_id,
            "type" => $type,
            "wish_value" => $wish_value,
        ]);
    }

    /**
     * 脑洞上下架
     *
     * @param  string $_id 脑洞id [ require true ]
     * @param  string $is_released 是否上架 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function releasedThink (string $_id, string $is_released) {
        return self::getClass()->releasedThink([
            "_id" => $_id,
            "is_released" => $is_released,
        ]);
    }

    /**
     * 删除脑洞类型
     *
     * @param  string $type_id 类型id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delThinkType (string $type_id) {
        return self::getClass()->delThinkType([
            "type_id" => $type_id,
        ]);
    }

    /**
     * 脑洞评选
     *
     * @param  array $_ids 脑洞id [ require true ]
     * @param  string $appraise 评选 [ require true ]
     * @param  int $appraiseVal 评选分值 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function thinkAppraise (array $_ids, string $appraise, int $appraiseVal) {
        return self::getClass()->thinkAppraise([
            "_ids" => $_ids,
            "appraise" => $appraise,
            "appraiseVal" => $appraiseVal,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'ThinkManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'ThinkManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}