<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addUpYunSignByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method collectEnergyByParams(array $params)
 * @method exportByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method getAwardDetailByParams(array $params)
 * @method getUpYunHostByParams(array $params)
 * @method creditExchangeByParams(array $params)
 * @method createGroupByParams(array $params)
 * @method getGroupListByParams(array $params)
 * @method editGroupByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加又拍云配置
     *
     * @param  string $upyun_key upyun_key [ require true ]
     * @param  string $prefix 地址前缀 [ require true ]
     * @param  string $save_key 保存key [ require true ]
     * @param  string $bucket 空间名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addUpYunSign (string $upyun_key, string $prefix, string $save_key, string $bucket) {
        return self::getClass()->addUpYunSign([
            "upyun_key" => $upyun_key,
            "prefix" => $prefix,
            "save_key" => $save_key,
            "bucket" => $bucket,
        ]);
    }

    /**
     * 获取又拍云上传签名
     *
     * @param  string $upyun_key key [ require true ]
     * @param  bool $isDown key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign (string $upyun_key, bool $isDown = false) {
        return self::getClass()->getUpyunSign([
            "upyun_key" => $upyun_key,
            "isDown" => $isDown,
        ]);
    }

    /**
     * 领取点子-计算愿望值【暂不考虑每日领取情况】
     *
     * @param  array $ids id数组 [ require true ]
     * @param  int $score 愿望值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function collectEnergy (array $ids, int $score) {
        return self::getClass()->collectEnergy([
            "ids" => $ids,
            "score" => $score,
        ]);
    }

    /**
     * 导出数据【愿望|脑洞】
     *
     * @support  string $state 状态（wait_review-待审核 pass-通过 un_pass-未通过） 
     * @support  string $created_at_start 开始时间 
     * @support  string $created_at_end 结束时间 
     * @support  int $staff_num 用户工号 
     * @support  string $name 姓名 
     * @support  string $type_id 点子类型id 
     * @support  string $module 模块类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function export () {
        return self::getClass()->export();
    }

    /**
     * 获取管理员权限信息(存贮session信息)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 获取领取详情
     *
     * @support  string $from 数据来源 
     * @support  string $type 类型 
     * @support  string $from_id 数据来源的id 
     * @support  int $score 愿望值数量 [Original type uint] 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页数量 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getAwardDetail () {
        return self::getClass()->getAwardDetail();
    }

    /**
     * 获取又拍云prefix
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUpYunHost () {
        return self::getClass()->getUpYunHost();
    }

    /**
     * 门店培训积分兑换
     *
     * @param  int $staff_num 工号 [ require true ]
     * @param  int $wish_val 愿望值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function creditExchange (int $staff_num, int $wish_val) {
        return self::getClass()->creditExchange([
            "staff_num" => $staff_num,
            "wish_val" => $wish_val,
        ]);
    }

    /**
     * 创建组
     *
     * @param  string $groupName 用户组名称 [ require true ]
     * @param  array $rules 规则组[[&#039;department_id&#039; =&gt; &#039;&#039;, &#039;job_id&#039; =&gt; &#039;&#039;, &#039;level&#039; =&gt; &#039;&#039;]] [ require true ]
     * @param  array $includes 包含的staffIds [ require true ]
     * @param  array $excludes 排除的staffIds [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createGroup (string $groupName, array $rules = [], array $excludes = [], array $includes = []) {
        return self::getClass()->createGroup([
            "groupName" => $groupName,
            "rules" => $rules,
            "excludes" => $excludes,
            "includes" => $includes,
        ]);
    }

    /**
     * 组列表
     *
     * @support  string $application 组来源 [ require true ]
     * @support  string $groupName 组名 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupList () {
        return self::getClass()->getGroupList();
    }

    /**
     * rules || includes || excludes 不传则删除原有
     *
     * @param  int $groupId 用户组ID [Original type uint] [ require true ]
     * @param  string $groupName 用户组名称 [ require true ]
     * @param  array $rules 规则组[[&#039;department_id&#039; =&gt; &#039;&#039;, &#039;job_id&#039; =&gt; &#039;&#039;, &#039;level&#039; =&gt; &#039;&#039;]] [ require true ]
     * @param  array $includes 包含的staffIds [ require true ]
     * @param  array $excludes 排除的staffIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editGroup (int $groupId, string $groupName, array $rules = [], array $excludes = [], array $includes = []) {
        return self::getClass()->editGroup([
            "groupId" => $groupId,
            "groupName" => $groupName,
            "rules" => $rules,
            "excludes" => $excludes,
            "includes" => $includes,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}