<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\Partner;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSuggestionListByParams(array $params)
 * @method getDetailByIdByParams(array $params)
 * @method addSuggestionByParams(array $params)
 */
class Suggestion {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 投诉与建议列表
     *
     * @support  string $suggestionType 投诉与建议：类型 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSuggestionList (int $page, int $pageSize) {
        return self::getClass()->getSuggestionList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取 投诉与建议 详情
     *
     * @support  int $id 投诉/建议 详情id 
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailById () {
        return self::getClass()->getDetailById();
    }

    /**
     * 新增：投诉/建议
     *
     * @support  string $type 类型：complaint/suggestion [ require true ]
     * @support  array $topic 反馈主题（传英文标记，如果为空，传空数组） [ require true ]
     * @support  string $content 内容（字数限制 2000 个字） [ require true ]
     * @support  array $images 图片 URL 数组（如果为空，传空数组） 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addSuggestion () {
        return self::getClass()->addSuggestion();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\Partner\Suggestion');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\Partner\Suggestion');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}