<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\Partner;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method configListByParams(array $params)
 * @method getSuggestionListByParams(array $params)
 * @method getDetailByIdByParams(array $params)
 * @method replyMessageByParams(array $params)
 * @method markMessageByParams(array $params)
 */
class Suggestion {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 投诉与建议列表：搜索配置参数
     *
     * @throws  \Exception
     * @return  array
     */
    public static function configList () {
        return self::getClass()->configList();
    }

    /**
     * 投诉与建议列表
     *
     * @support  int $departmentId 部门id 
     * @support  string $staff 姓名，花名，或工号 
     * @support  string $suggestionType 投诉与建议：类型 
     * @support  string $suggestionTopic 投诉与建议：主题 
     * @support  string $suggestionDepartment 投诉与建议：问题归属部门 
     * @support  int $isDeal 处理结果：不传查询all，1 已处理，0 未处理 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSuggestionList (int $page, int $pageSize) {
        return self::getClass()->getSuggestionList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取 投诉与建议 详情
     *
     * @support  int $id 投诉/建议 详情id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailById () {
        return self::getClass()->getDetailById();
    }

    /**
     * 管理员回复消息
     *
     * @support  int $id 投诉/建议消息 id [ require true ]
     * @support  string $replyContent 回复内容（字数限制 2000 个字） [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function replyMessage () {
        return self::getClass()->replyMessage();
    }

    /**
     * 管理员标记消息
     *
     * @support  int $id 投诉/建议消息 id [ require true ]
     * @support  array $departments 问题归属部门（未选中，默认传空数组） 
     * @throws  \Exception
     * @return  mixed
     */
    public static function markMessage () {
        return self::getClass()->markMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\Partner\Suggestion');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\Partner\Suggestion');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}