<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\User\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCoffeeCouponListByParams(array $params)
 * @method cronCoffeeCouponsByParams(array $params)
 * @method getCouponInfoByParams(array $params)
 * @method checkCoffeeCouponByParams(array $params)
 * @method exportCoffeeCouponListByParams(array $params)
 */
class CouponCoffee {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 咖啡券列表
     *
     * @param  bool $isUsed 是否已使用 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCoffeeCouponList (bool $isUsed) {
        return self::getClass()->getCoffeeCouponList([
            "isUsed" => $isUsed,
        ]);
    }

    /**
     * 发放咖啡券定时任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCoffeeCoupons () {
        return self::getClass()->cronCoffeeCoupons();
    }

    /**
     * 移除登录权限判断，微信端打开没有权限判断
     *
     * @support  int $couponId 咖啡券id [Original type uint] [ require true ]
     * @support  int $staffId staffId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponInfo () {
        return self::getClass()->getCouponInfo();
    }

    /**
     * 移除登录权限判断，微信端打开没有权限判断
     *
     * @param  int $couponId 咖啡券id [Original type uint] [ require true ]
     * @param  int $staffId staffId [Original type uint] [ require true ]
     * @param  string $prodName 商品名称 [ require true ]
     * @param  float $prodPrice 商品原价 [Original type unsignedDouble] [ require true ]
     * @param  string $openid 微信openid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkCoffeeCoupon (int $couponId, int $staffId, string $prodName, float $prodPrice, string $openid) {
        return self::getClass()->checkCoffeeCoupon([
            "couponId" => $couponId,
            "staffId" => $staffId,
            "prodName" => $prodName,
            "prodPrice" => $prodPrice,
            "openid" => $openid,
        ]);
    }

    /**
     * 咖啡券列表.导出
     *
     * @support  string $beginAt 开始日期 
     * @support  string $endAt 结束日期 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exportCoffeeCouponList (int $page, int $pageSize) {
        return self::getClass()->exportCoffeeCouponList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'User\SpaceStation\CouponCoffee');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'User\SpaceStation\CouponCoffee');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}