<?php
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createNoticeByParams(array $params)
 * @method getNoticeListByParams(array $params)
 * @method releaseNoticeByParams(array $params)
 * @method editNoticeByParams(array $params)
 * @method getNoticeDetailByParams(array $params)
 */
class NoticeManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建公告
     *
     * @support  string $title 标题 [ require true ]
     * @support  array $type 公告类型【愿望堡、脑洞】 [ require true ]
     * @support  array $images 图片地址 [ require true ]
     * @support  string $content 公告内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createNotice () {
        return self::getClass()->createNotice();
    }

    /**
     * 获取公告列表
     *
     * @support  string $state 状态位 
     * @support  string $type 类型 
     * @support  string $title 标题 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getNoticeList () {
        return self::getClass()->getNoticeList();
    }

    /**
     * 公告上线
     *
     * @param  string $_id 公告id [ require true ]
     * @param  string $state 公告状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function releaseNotice (string $_id, string $state) {
        return self::getClass()->releaseNotice([
            "_id" => $_id,
            "state" => $state,
        ]);
    }

    /**
     * 编辑公告
     *
     * @support  string $_id id [ require true ]
     * @support  array $type 类型 
     * @support  array $images 图片 
     * @support  string $title 标题 
     * @support  string $content 公告内容 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editNotice () {
        return self::getClass()->editNotice();
    }

    /**
     * 获取公告详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNoticeDetail (string $_id) {
        return self::getClass()->getNoticeDetail([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'NoticeManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'NoticeManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}