<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method departmentTreeByParams(array $params)
 * @method syncAddDepartmentByParams(array $params)
 * @method syncEditDepartmentByParams(array $params)
 * @method syncDeleteDepartmentByParams(array $params)
 */
class Department {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 部门树结构
     *
     * @throws  \Exception
     * @return  array
     */
    public static function departmentTree () {
        return self::getClass()->departmentTree();
    }

    /**
     * 架构添加监听
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncAddDepartment () {
        return self::getClass()->syncAddDepartment();
    }

    /**
     * 架构修改监听
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncEditDepartment () {
        return self::getClass()->syncEditDepartment();
    }

    /**
     * 架构修改监听
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncDeleteDepartment () {
        return self::getClass()->syncDeleteDepartment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'SpaceStation\Department');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'SpaceStation\Department');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}