<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSpaceStationIndexByParams(array $params)
 * @method getActivityListByParams(array $params)
 * @method getActivityByParams(array $params)
 * @method signupActivityByParams(array $params)
 * @method getMyActivityListByParams(array $params)
 * @method getInformationListByParams(array $params)
 * @method getInformationByParams(array $params)
 */
class SpaceStation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSpaceStationIndex (int $page, int $pageSize) {
        return self::getClass()->getSpaceStationIndex([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  string $status 报名状态，signing 报名中，signed 已结束，signtodo 即将开始 [ require true ]
     * @param  string $type 活动类型，knowledge 表示知识补给，energy 表示能量空间 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityList (string $status, string $type, int $page, int $pageSize) {
        return self::getClass()->getActivityList([
            "status" => $status,
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivity (int $id) {
        return self::getClass()->getActivity([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function signupActivity (int $id) {
        return self::getClass()->signupActivity([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMyActivityList (int $page, int $pageSize) {
        return self::getClass()->getMyActivityList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  string $type 资讯类型，assistant 表示生活助手，outerWelfare 表示外部福利 [ require true ]
     * @support  string $title 标题 
     * @support  bool $isAll 是否查询全部 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInformationList (string $type, int $page, int $pageSize) {
        return self::getClass()->getInformationList([
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 资讯id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInformation (int $id) {
        return self::getClass()->getInformation([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'SpaceStation\SpaceStation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'SpaceStation\SpaceStation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}