<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInformationListByParams(array $params)
 * @method addInformationByParams(array $params)
 * @method editInformationByParams(array $params)
 * @method deleteInformationByParams(array $params)
 * @method getInformationByParams(array $params)
 */
class Information {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @support  string $title 标题 
     * @support  string $type 资讯类型，information 表示生活助手，welfare 表示外部合作福利  
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInformationList (int $page, int $pageSize) {
        return self::getClass()->getInformationList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @support  string $title 标题 [ require true ]
     * @support  string $abstract 概要 
     * @support  string $coverImage 封面图 [ require true ]
     * @support  string $description 资讯正文 [ require true ]
     * @support  string $type 资讯类型，assistant 表示生活助手，welfare 表示外部合作福利  [ require true ]
     * @support  array $extraInfo 可传空，格式：外部跳转 [ selected:1, url:http:xxxxxx]; 1 为外部跳转，0 为无 
     * @support  array $groupTypes 传递[dep[&#039;deptId&#039;, &#039;deptId&#039;]]格式 
     * @support  array $extraStaff staffIds的数组集合 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addInformation () {
        return self::getClass()->addInformation();
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @support  int $id 资讯id [Original type uint] [ require true ]
     * @support  string $title 标题 
     * @support  string $abstract 概要 
     * @support  string $coverImage 封面图 
     * @support  string $description 资讯正文 
     * @support  string $type 资讯类型，assistant 表示生活助手，welfare 表示外部合作福利  
     * @support  array $extraInfo 可传空，格式：外部跳转 [ selected:1, url:http:xxxxxx]; 1 为外部跳转，0 为无 
     * @support  array $groupTypes 传递[dep[&#039;deptId&#039;, &#039;deptId&#039;]]格式 
     * @support  array $extraStaff staffIds的数组集合 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editInformation () {
        return self::getClass()->editInformation();
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 资讯id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteInformation (int $id) {
        return self::getClass()->deleteInformation([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 资讯id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInformation (int $id) {
        return self::getClass()->getInformation([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'SpaceStation\Information');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'SpaceStation\Information');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}