<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityListByParams(array $params)
 * @method addActivityByParams(array $params)
 * @method editActivityByParams(array $params)
 * @method deleteActivityByParams(array $params)
 * @method getActivityByParams(array $params)
 * @method getActivityStaffListByParams(array $params)
 * @method cancelActivitySignupByParams(array $params)
 * @method resumeActivitySignupByParams(array $params)
 * @method signupActivityBatchByParams(array $params)
 * @method getSignupedAndCanceledStaffsByParams(array $params)
 * @method sendDingNotifyByParams(array $params)
 * @method sendDingNotifyBeforeHalfHourByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @support  string $name 名称 
     * @support  string $type 活动类型，knowledge 表示知识补给，energy 表示能量空间  
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityList (int $page, int $pageSize) {
        return self::getClass()->getActivityList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $signStartAt 报名开始时间 [ require true ]
     * @support  string $signEndAt 报名结束时间 [ require true ]
     * @support  string $startAt 活动开始时间 [ require true ]
     * @support  string $endAt 活动结束时间 [ require true ]
     * @support  string $address 活动地址 
     * @support  string $coverImage 封面图 [ require true ]
     * @support  string $description 活动描述 [ require true ]
     * @support  int $numberLimit 人数限制 [Original type uint] 
     * @support  string $type 活动类型，knowledge 表示知识补给，energy 表示能量空间  [ require true ]
     * @support  array $typeDetail 可传空，格式：知识补给：[score:30, url:http:xxx] 或 能量空间 [needTicket:1] 1为需要，0为不需要 
     * @support  array $groupTypes 传递[dep[&#039;deptId&#039;, &#039;deptId&#039;]]格式 
     * @support  array $extraStaff staffIds的数组集合 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addActivity () {
        return self::getClass()->addActivity();
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @support  int $id 活动id [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  string $signStartAt 报名开始时间 
     * @support  string $signEndAt 报名结束时间 
     * @support  string $startAt 活动开始时间 
     * @support  string $endAt 活动结束时间 
     * @support  string $address 活动地址 
     * @support  string $coverImage 封面图 
     * @support  string $description 活动描述 
     * @support  int $numberLimit 人数限制 [Original type uint] 
     * @support  string $type 活动类型，knowledge 表示知识补给，energy 表示能量空间  
     * @support  array $typeDetail 可传空，格式：知识补给：[score:30, url:http:xxx] 或 能量空间 [needTicket:1] 1为需要，0为不需要 
     * @support  array $groupTypes 传递[dep[&#039;deptId&#039;, &#039;deptId&#039;]]格式 
     * @support  array $extraStaff staffIds的数组集合 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editActivity () {
        return self::getClass()->editActivity();
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteActivity (int $id) {
        return self::getClass()->deleteActivity([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivity (int $id) {
        return self::getClass()->getActivity([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @support  string $staff 姓名，花名，或工号 
     * @support  bool $isSignin 签到状态 
     * @support  bool $isSignup 报名状态，不传查询all，1 表报名，0 表未报名，2 表已取消 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityStaffList (int $id, int $page, int $pageSize) {
        return self::getClass()->getActivityStaffList([
            "id" => $id,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 活动记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelActivitySignup (int $id) {
        return self::getClass()->cancelActivitySignup([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 活动记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resumeActivitySignup (int $id) {
        return self::getClass()->resumeActivitySignup([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @support  array $deptIds 传递deptId的数组集合 
     * @support  array $staffIds staffId的数组集合 
     * @throws  \Exception
     * @return  mixed
     */
    public static function signupActivityBatch (int $id) {
        return self::getClass()->signupActivityBatch([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSignupedAndCanceledStaffs (int $id) {
        return self::getClass()->getSignupedAndCanceledStaffs([
            "id" => $id,
        ]);
    }

    /**
     * RpcAuthority(need=&quot;manager.base&quot;)
     *
     * @param  array $staffIds staffId 数组集合 [ require true ]
     * @param  string $title 标题 [ require true ]
     * @param  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDingNotify (array $staffIds, string $title, string $content) {
        return self::getClass()->sendDingNotify([
            "staffIds" => $staffIds,
            "title" => $title,
            "content" => $content,
        ]);
    }

    /**
     * 一分钟执行一次查询
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDingNotifyBeforeHalfHour () {
        return self::getClass()->sendDingNotifyBeforeHalfHour();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\SpaceStation\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\SpaceStation\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}