<?php
namespace Mainto\Bridge\Invokes\ProjectTempActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCouponByParams(array $params)
 * @method sendMessageByParams(array $params)
 */
class RushToWuhan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户领取优惠券
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $activityId 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCoupon (string $phone, string $activityId) {
        return self::getClass()->getCoupon([
            "phone" => $phone,
            "activityId" => $activityId,
        ]);
    }

    /**
     * 发送微信通知
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $activityId 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMessage (string $phone, string $activityId) {
        return self::getClass()->sendMessage([
            "phone" => $phone,
            "activityId" => $activityId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTempActivity', 'RushToWuhan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTempActivity', 'RushToWuhan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}