<?php
namespace Mainto\Bridge\Invokes\ProjectTempActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendWinningNoticeByParams(array $params)
 */
class Prize {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送中奖通知
     *
     * @param  array $staff 伙伴工号 [ require true ]
     * @param  string $level 奖品等级 [ require true ]
     * @param  string $prize 奖品内容 [ require true ]
     * @param  string $type 总部或门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWinningNotice (array $staff, string $level, string $prize, string $type) {
        return self::getClass()->sendWinningNotice([
            "staff" => $staff,
            "level" => $level,
            "prize" => $prize,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTempActivity', 'Prize');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTempActivity', 'Prize');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}