<?php
namespace Mainto\Bridge\Invokes\ProjectTempActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendWorkNoticeByAwardByParams(array $params)
 * @method getAwardContentByParams(array $params)
 */
class Award {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据奖项发送钉钉工作通知
     *
     * @param  int $award 奖项ID [ require true ]
     * @param  bool $test 测试 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWorkNoticeByAward (int $award, bool $test = true) {
        return self::getClass()->sendWorkNoticeByAward([
            "award" => $award,
            "test" => $test,
        ]);
    }

    /**
     * 获取奖项内容
     *
     * @param  int $award 奖项ID [ require true ]
     * @param  bool $test 测试 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAwardContent (int $award, bool $test = false) {
        return self::getClass()->getAwardContent([
            "award" => $award,
            "test" => $test,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTempActivity', 'Award');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTempActivity', 'Award');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}