<?php
namespace Mainto\Bridge\Invokes\ProjectTempActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkStaffInfoByParams(array $params)
 * @method getCouponByParams(array $params)
 * @method getStoreSortByParams(array $params)
 * @method getPushMessageByParams(array $params)
 */
class Marketing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检验工号是否适合标准
     *
     * @param  int $staffId 用户手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkStaffInfo (int $staffId) {
        return self::getClass()->checkStaffInfo([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 用户领取优惠券
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  int $staffId 员工工号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCoupon (string $phone, string $code, int $staffId) {
        return self::getClass()->getCoupon([
            "phone" => $phone,
            "code" => $code,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取门店排名信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreSort () {
        return self::getClass()->getStoreSort();
    }

    /**
     * 获取获奖消息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPushMessage () {
        return self::getClass()->getPushMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTempActivity', 'Marketing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTempActivity', 'Marketing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}