<?php
namespace Mainto\Bridge\Invokes\ProjectSupportDomain\RetailOder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRetailOrderDetailByParams(array|\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\RetailOrder\RetailOrderCMD $params)
 */
class RetailOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取零售订单详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupportDomain\CMD\RetailOrder\RetailOrderCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupportDomain\DTO\RetailOrder\RetailOrderDetailDTO
     */
    public static function getRetailOrderDetail (\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\RetailOrder\RetailOrderCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRetailOrderDetail($cmd),
            "\Mainto\Bridge\Structs\ProjectSupportDomain\DTO\RetailOrder\RetailOrderDetailDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupportDomain', 'RetailOder\RetailOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupportDomain', 'RetailOder\RetailOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}