<?php
namespace Mainto\Bridge\Invokes\ProjectSupportDomain\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserProtocolListByParams(array|\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\QueryUserProtocolCMD $params)
 * @method setProtocolVersionsByParams(array|\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\SetUserProtocolCMD $params)
 * @method getUserProtocolListV1ByParams(array|\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\QueryUserProtocolCMD $params)
 * @method setProtocolVersionsV1ByParams(array|\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\SetUserProtocolCMD $params)
 */
class UserProtocol {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量获取用户协议
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\QueryUserProtocolCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupportDomain\DTO\User\UserProtocol\UserProtocolDTO[]
     */
    public static function getUserProtocolList (\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\QueryUserProtocolCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserProtocolList($cmd),
            "\Mainto\Bridge\Structs\ProjectSupportDomain\DTO\User\UserProtocol\UserProtocolDTO[]"
        );
    }


    /**
     * 批量同意预约协议版本
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\SetUserProtocolCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setProtocolVersions (\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\SetUserProtocolCMD $cmd) {
        return self::getClass()->setProtocolVersions($cmd);
    }


    /**
     * 批量获取用户协议- APP
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\QueryUserProtocolCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupportDomain\DTO\User\UserProtocol\UserProtocolDTO[]
     */
    public static function getUserProtocolListV1 (\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\QueryUserProtocolCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserProtocolListV1($cmd),
            "\Mainto\Bridge\Structs\ProjectSupportDomain\DTO\User\UserProtocol\UserProtocolDTO[]"
        );
    }


    /**
     * 批量同意预约协议版本 - APP
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\SetUserProtocolCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setProtocolVersionsV1 (\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\User\UserProtocolCMD\SetUserProtocolCMD $cmd) {
        return self::getClass()->setProtocolVersionsV1($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupportDomain', 'User\UserProtocol');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupportDomain', 'User\UserProtocol');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}