<?php
namespace Mainto\Bridge\Invokes\ProjectSupportDomain\CropTool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPictureMeasuresByParams(array|\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\CropTool\PictureMeasure\PictureMeasureCMD $params)
 */
class PictureMeasure {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 剪裁方案
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupportDomain\CMD\CropTool\PictureMeasure\PictureMeasureCMD $pictureMeasureCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupportDomain\DTO\CropTool\PictureMeasure\PictureMeasureDTO[]
     */
    public static function getPictureMeasures (\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\CropTool\PictureMeasure\PictureMeasureCMD $pictureMeasureCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPictureMeasures($pictureMeasureCMD),
            "\Mainto\Bridge\Structs\ProjectSupportDomain\DTO\CropTool\PictureMeasure\PictureMeasureDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupportDomain', 'CropTool\PictureMeasure');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupportDomain', 'CropTool\PictureMeasure');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}