<?php
namespace Mainto\Bridge\Invokes\ProjectSupportDomain\CropTool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPictureMeasuresByParams(array|\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\CropTool\Crop\PictureMeasureCMD $params)
 * @method getCropDetailByParams(array|\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\CropTool\Crop\CropCMD $params)
 */
class Crop {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 可用剪裁方案列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupportDomain\CMD\CropTool\Crop\PictureMeasureCMD $pictureMeasureCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupportDomain\DTO\CropTool\Crop\PictureMeasureDTO[]
     */
    public static function getPictureMeasures (\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\CropTool\Crop\PictureMeasureCMD $pictureMeasureCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPictureMeasures($pictureMeasureCMD),
            "\Mainto\Bridge\Structs\ProjectSupportDomain\DTO\CropTool\Crop\PictureMeasureDTO[]"
        );
    }


    /**
     * 剪裁细节
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupportDomain\CMD\CropTool\Crop\CropCMD $cropCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupportDomain\DTO\CropTool\Crop\CropDetailDTO
     */
    public static function getCropDetail (\Mainto\Bridge\Structs\ProjectSupportDomain\CMD\CropTool\Crop\CropCMD $cropCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCropDetail($cropCMD),
            "\Mainto\Bridge\Structs\ProjectSupportDomain\DTO\CropTool\Crop\CropDetailDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupportDomain', 'CropTool\Crop');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupportDomain', 'CropTool\Crop');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}