<?php
namespace Mainto\Bridge\Invokes\ProjectSupportDomain\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|\Mainto\Bridge\Structs\ProjectSupportDomain\Index\Cmd\Health\HealthCmd $params)
 */
class Health {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 健康检查
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupportDomain\Index\Cmd\Health\HealthCmd $healthCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupportDomain\Index\DTO\Health\HealthDTO
     */
    public static function detail (\Mainto\Bridge\Structs\ProjectSupportDomain\Index\Cmd\Health\HealthCmd $healthCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($healthCmd),
            "\Mainto\Bridge\Structs\ProjectSupportDomain\Index\DTO\Health\HealthDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupportDomain', 'Index\Health');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupportDomain', 'Index\Health');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}